/******************************************************************************
* (C) Copyright 2007 by Agilent Technologies, All Rights Reserved.
******************************************************************************/

#ifndef PCIEMEMORYMGMT_H
#define PCIEMEMORYMGMT_H

#define PCIEMEMORYMGMT_NOFHWCHANNELS  ( ( UInt8 )PCIE_HWCHANNEL_FUNCTION_END )
#define PCIEMEMORYMGMT_NOFQUEUES      ( ( UInt8 )PCIE_COMPQUEUE_END )

class CPCIEMemoryMgmt
{
public:

  CPCIEMemoryMgmt( void );
  ~CPCIEMemoryMgmt( void );

  enum LineType
  {
    MEMORYMGMT_LINETYPE_BLOCK,
    MEMORYMGMT_LINETYPE_REQBEH,
    MEMORYMGMT_LINETYPE_COMPBEH
  };

  enum BlockLineType
  {
    MEMORYMGMT_BLOCKLINETYPE_MEM64,
    MEMORYMGMT_BLOCKLINETYPE_MEM32,
    MEMORYMGMT_BLOCKLINETYPE_IO,
    MEMORYMGMT_BLOCKLINETYPE_MSGAS,
    MEMORYMGMT_BLOCKLINETYPE_CFG,
    MEMORYMGMT_BLOCKLINETYPE_MSG,
    MEMORYMGMT_BLOCKLINETYPE_MSGASD,
    MEMORYMGMT_BLOCKLINETYPE_UNKNOWN,
    MEMORYMGMT_BLOCKLINETYPE_NOFENTRIES
  };

  struct BlockProp
  {
    bool mBlock[PCIE_MAX_BLOCKPROP_NUM];
  };

  BlockProp mBlockLineValid[MEMORYMGMT_BLOCKLINETYPE_NOFENTRIES];

  // Memory line
  void BlockSet( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& channel, const UInt32& line,
    const EPCIEBlock& prop, const UInt32& val );
  UInt32 BlockGet( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& channel, const UInt32& line,
    const EPCIEBlock& prop );
  void BlockLineWrite( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& channel, const UInt32& line,
    const UInt32& numBytes, const UInt8* mData );
  void BlockLineRead( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& channel, const UInt32& line,
    const UInt32& numBytes, UInt8* theData );
  void BlockLineDefaultSet( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& channel,
    const UInt32& lineNum );
  void BlockLineDefaultInsert( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& channel,
    const UInt32& lineNum );
  void BlockLineDelete( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& channel,
    const UInt32& lineNum );
  UInt32 BlockLineCountGet( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& channel );

  void ReqBehSet( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& channel, const UInt32& line,
    const EPCIEReqBeh& prop, const UInt32& val );
  UInt32 ReqBehGet( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& channel, const UInt32& line,
    const EPCIEReqBeh& prop );
  void ReqBehLineWrite( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& channel, const UInt32& line,
    const UInt32& numBytes, const UInt8* mData );
  void ReqBehLineRead( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& channel, const UInt32& line,
    const UInt32& numBytes, UInt8* theData );
  void ReqBehLineDefaultSet( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& channel,
    const UInt32& lineNum );
  void ReqBehLineDefaultInsert( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& channel,
    const UInt32& lineNum );
  void ReqBehLineDelete( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& channel,
    const UInt32& lineNum );
  UInt32 ReqBehLineCountGet( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& channel );

  void CompBehSet( const AgtPortHandleT& portHandle, const EPCIECompQueue& queue, const UInt32& line,
    const EPCIECompBeh& prop, const UInt32& val );
  UInt32 CompBehGet( const AgtPortHandleT& portHandle, const EPCIECompQueue& queue, const UInt32& line,
    const EPCIECompBeh& prop );
  void CompBehLineWrite( const AgtPortHandleT& portHandle, const EPCIECompQueue& queue, const UInt32& line,
    const UInt32& numBytes, const UInt8* mData );
  void CompBehLineRead( const AgtPortHandleT& portHandle, const EPCIECompQueue& queue, const UInt32& line,
    const UInt32& numBytes, UInt8* theData );
  void CompBehLineDefaultSet( const AgtPortHandleT& portHandle, const EPCIECompQueue& queue, const UInt32& lineNum );
  void CompBehLineDefaultInsert( const AgtPortHandleT& portHandle, const EPCIECompQueue& queue,
    const UInt32& lineNum );
  void CompBehLineDelete( const AgtPortHandleT& portHandle, const EPCIECompQueue& queue, const UInt32& lineNum );
  UInt32 CompBehLineCountGet( const AgtPortHandleT& portHandle, const EPCIECompQueue& queue );

  void BlockGenWrite( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& channel,
    const EPCIEBlockGen& prop, const UInt32& val );
  UInt32 BlockGenRead( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& channel,
    const EPCIEBlockGen& prop );
  void BlockGenDefaultWrite( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& channel );

  void ReqBehGenWrite( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& channel,
    const EPCIEReqBehGen& prop, const UInt32& val );
  UInt32 ReqBehGenRead( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& channel,
    const EPCIEReqBehGen& prop );
  void ReqBehGenDefaultWrite( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& channel );

  void CompBehGenWrite( const AgtPortHandleT& portHandle, const EPCIECompQueue& queue, const EPCIECompBehGen& prop,
    const UInt32& val );
  UInt32 CompBehGenRead( const AgtPortHandleT& portHandle, const EPCIECompQueue& queue, const EPCIECompBehGen& prop );
  void CompBehGenDefaultWrite( const AgtPortHandleT& portHandle, const EPCIECompQueue& queue );

  void RequesterRun( const AgtPortHandleT& portHandle );
  void RequesterStop( const AgtPortHandleT& portHandle );

  void CompleterRun( const AgtPortHandleT& portHandle );
  UInt32 GetHWChannelState( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& channel );

private:

  void LineWrite( const AgtPortHandleT& portHandle, const CPCIEMemoryMgmt::LineType&, const UInt8&, const UInt32&,
    const UInt32&, const UInt8* );
  void LineRead( const AgtPortHandleT& portHandle, const CPCIEMemoryMgmt::LineType&, const UInt8&, const UInt32&,
    const UInt32&, UInt8* );

  // Block memories
  UInt32 mBlockLineCount[PCIE_MAXIMUM_NUMBER_OF_PROBE_BOARDS][PCIEMEMORYMGMT_NOFHWCHANNELS];
  UInt32 mReqBehLineCount[PCIE_MAXIMUM_NUMBER_OF_PROBE_BOARDS][PCIEMEMORYMGMT_NOFHWCHANNELS];
  UInt32 mCompBehLineCount[PCIE_MAXIMUM_NUMBER_OF_PROBE_BOARDS][PCIEMEMORYMGMT_NOFQUEUES];

  UInt32 mBlockGenEnabled[PCIE_MAXIMUM_NUMBER_OF_PROBE_BOARDS][PCIEMEMORYMGMT_NOFHWCHANNELS];

  // These two properties are obsolete but remain in here for compatiblity reasons
  // i.e.: read/write still work but has no effect. This will prevent code from 
  // customer suddenly not working any more ...(MR)
  UInt32 mReqBehGenEnabled[PCIEMEMORYMGMT_NOFHWCHANNELS];
  UInt32 mCompBehGenEnabled[PCIEMEMORYMGMT_NOFQUEUES];

  bool mSingleShotEnabled[PCIE_MAXIMUM_NUMBER_OF_PROBE_BOARDS][PCIEMEMORYMGMT_NOFHWCHANNELS];

  void updateRepeatFirst_Block ( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& channel );
  void updateRepeatFirst_ReqBeh( const AgtPortHandleT& portHandle, const EPCIEHwChannelFunction& channel );
  void updateRepeatFirst_CplBeh( const AgtPortHandleT& portHandle, const EPCIECompQueue& queue );
};

#endif /* PCIEMEMORYMGMT_H */